IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='PDV_VD_CLIENTE_CONTROLE_ENVIO') 
BEGIN
	CREATE TABLE [dbo].[PDV_VD_CLIENTE_CONTROLE_ENVIO](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_VD] [int] NOT NULL,
		[CD_CX] [int] NOT NULL,
		[NR_ECF] [int] NULL,
		[DT_VD] [datetime] NULL,
		[TIPO_EMISSAO] [int] NULL,
		[STATUS_ENVIO] [int] NULL,
		[MENSAGEM_RETORNO_ENVIO] [varchar](500) NULL,

		CONSTRAINT [PK_PDV_VD_CLIENTE_CONTROLE_ENVIO] PRIMARY KEY  
		(
			[CD_VD] ASC,
			[CD_FILIAL] ASC,
			[CD_EMP] ASC
		),

		CONSTRAINT [UC_PDV_VD_CLIENTE_CONTROLE_ENVIO] UNIQUE (
			[CD_EMP] ASC,
			[CD_FILIAL] ASC,
			[CD_CX] ASC,
			[NR_ECF] ASC,
			[DT_VD] ASC
		)
	)

	ALTER TABLE [dbo].[PDV_VD_CLIENTE_CONTROLE_ENVIO]  WITH CHECK ADD  CONSTRAINT [FK_PDV_VD_CLIENTE_CONTROLE_ENVIO_PDV_VD] FOREIGN KEY([CD_VD],[CD_FILIAL],[CD_EMP])
	REFERENCES [dbo].[PDV_VD] ([CD_VD],[CD_FILIAL],[CD_EMP])

END